import { BackHandler, Text, View } from "react-native";
import { WebView } from "react-native-webview";
import CommonStyles from "../Utilities/CommonStyles/CommonStyles";
import useLangTranslation from "../../hooks/useLangTranslation";
import { useEffect, useState } from "react";
import { InOnScreenLoader } from "../ShoppingCart/ShoppingCart";
import useGuestUser from "../../hooks/useGuestUser";

const PaymentView = (props) => {
    const { trans } = useLangTranslation();
    const isGuest = useGuestUser();
    const { url, itemId } = props?.route?.params || {};

    const [loading, setLoading] = useState(true);

    const handleLoad = () => {
        setLoading(false);
    };

    let controlBackHandler;
    useEffect(() => {
        controlBackHandler = BackHandler.addEventListener(
            'hardwareBackPress',
            () => true,
        );
    }, [props.navigation]);

    const getResponseFromView = (event) => {
        let paymentData = event.nativeEvent.data;
        paymentData = parseJson(paymentData);
        if (isGuest && paymentData.status == "failed") {
            props.navigation.navigate("Home");
            controlBackHandler?.remove();
        } else if (paymentData.status == "failed") {
            props.navigation.navigate("order history", { resetToHome: true });
            controlBackHandler?.remove();
        } else if (paymentData.status == "completed") {
            props.navigation.navigate("order done", {
                itemId,
                resetToHome: true,
            });
            controlBackHandler?.remove();
        } else if (paymentData.status == "pending") {
            props.navigation.navigate("order done", {
                itemId,
                resetToHome: true,
            });
            controlBackHandler?.remove();
        } else {
            props.navigation.navigate("Home");
            controlBackHandler?.remove();
        }
    };

    const parseJson = (parsableString) => {
        try {
            parsableString = JSON.parse(parsableString);
        } catch (e) { }
        return parsableString;
    };

    return (
        <>
            {loading && <InOnScreenLoader />}
            <View style={CommonStyles.container}>
                <View style={CommonStyles.customHeaderContainer}>
                    <Text style={CommonStyles.headerName}>{trans("Payment")}</Text>
                </View>
            </View>
            <WebView
                onMessage={getResponseFromView}
                source={{ uri: url }}
                incognito={true}
                onLoad={handleLoad}
            />
        </>
    );
};

export default PaymentView;
